/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.general;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.IVWUDDIPanelOperation;
import filenet.vw.toolkit.utils.ws.base.IVWUDDIBusinessStatusListener;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.vw.toolkit.utils.ws.general.VWUDDIDescriptionEditDialog;
import filenet.vw.toolkit.utils.ws.general.VWUDDIDescriptionTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.apache.juddi.datatype.Description;

public class VWUDDIBusinessGeneralDescPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWUDDIPanelOperation {
    private VWUDDIBusinessItem m_vwBusinessItem = null;
    private Frame m_parentFrame = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_descriptionTable = null;
    private VWUDDIDescriptionTableModel m_tableModel = null;
    private boolean m_bChanged = false;

    public VWUDDIBusinessGeneralDescPanel(Frame parent, VWUDDIBusinessItem businessItem) {
        try {
            this.m_parentFrame = parent;
            this.m_vwBusinessItem = businessItem;
            this.createControls();
            this.m_descriptionTable.clearSelection();
            if (this.m_descriptionTable.getRowCount() > 0) {
                this.m_descriptionTable.setRowSelectionInterval(0, 0);
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 32));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 1));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 2));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addBusinessStatusListener(IVWUDDIBusinessStatusListener listener) {
        this.m_tableModel.addBusinessStatusListener(listener);
    }

    public boolean hasChanged() {
        return this.m_bChanged || this.m_tableModel.hasChanged();
    }

    public void stopEditing() {
        if (this.m_descriptionTable != null) {
            this.m_descriptionTable.stopEditing();
        }
    }

    public boolean validateData() {
        return this.m_tableModel.verifyDescriptions();
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            this.stopEditing();
            if (this.m_tableModel.hasChanged() && (bSuccess = this.m_tableModel.verifyDescriptions())) {
                Vector descriptionList = this.m_tableModel.getVector();
                this.m_vwBusinessItem.setDescriptionVector(descriptionList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_errorMessage, 1);
        }
        return bSuccess;
    }

    public void resetBusinessInfo(VWUDDIBusinessItem businessItem) {
        this.stopEditing();
        this.m_vwBusinessItem = businessItem;
        this.m_tableModel.setBusinessEntity(this.m_vwBusinessItem);
        this.updateUI();
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                if (this.m_descriptionTable.getRowCount() <= 0) break;
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_descriptionTable.getSelectedRow()) {
                    this.m_descriptionTable.clearSelection();
                }
                this.m_descriptionTable.setRowSelectionInterval(nRow, nRow);
                this.m_descriptionTable.ensureRowIsVisible(nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            JPanel clientPanel = this.m_toolBarBorder.getClientPanel();
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 1));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 2));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 0x10000000));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 32));
            int nRowIndex = this.m_descriptionTable.getSelectedRow();
            int nRowCount = this.m_descriptionTable.getRowCount();
            if (this.m_tableModel != null && nRowIndex != -1) {
                if (nRowIndex > 0) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 1));
                }
                if (nRowIndex < nRowCount - 1) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 2));
                }
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 32));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_descriptionTable.setRowSelectionInterval(nRow, nRow);
                    this.m_descriptionTable.setColumnSelectionInterval(0, 0);
                    this.m_descriptionTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                    break;
                }
                case 32: {
                    this.onModifyText();
                    break;
                }
                case 1: {
                    this.onUp();
                    break;
                }
                case 2: {
                    this.onDown();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createControls() {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.createDescriptionsPanel();
            this.add((Component)this.m_toolBarBorder, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Vector getVector() {
        return this.m_tableModel.getVector();
    }

    public void resetTableData(Vector data) {
        this.m_tableModel.resetData(data);
    }

    public void releaseResources() {
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_descriptionTable != null) {
            this.m_descriptionTable.removeAll();
            this.m_descriptionTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.removeAll();
    }

    private void createDescriptionsPanel() {
        try {
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.s_businessDescription, 0x10000033);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_tableModel = new VWUDDIDescriptionTableModel(this.m_parentFrame, this.m_vwBusinessItem);
            this.m_tableModel.addTableModelListener(this);
            this.m_descriptionTable = new VWTable(this.m_tableModel);
            this.m_descriptionTable.setRowSelectionAllowed(true);
            this.m_descriptionTable.getSelectionModel().addListSelectionListener(this);
            this.m_descriptionTable.getSelectionModel().setSelectionMode(0);
            TableColumn tcElement = this.m_descriptionTable.getColumn(this.m_tableModel.getColumnName(0));
            if (tcElement != null) {
                tcElement.setMaxWidth(20);
            }
            if ((tcElement = this.m_descriptionTable.getColumn(this.m_tableModel.getColumnName(1))) != null) {
                tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            if ((tcElement = this.m_descriptionTable.getColumn(this.m_tableModel.getColumnName(2))) != null) {
                int columnWidth;
                tcElement.setCellEditor(new DefaultCellEditor(this.m_tableModel.getLanguageTypeComboBox()));
                try {
                    columnWidth = Integer.valueOf("130");
                }
                catch (Exception ex) {
                    columnWidth = 130;
                }
                tcElement.setMaxWidth(columnWidth);
                tcElement.setMinWidth(columnWidth);
            }
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_descriptionTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        boolean bYesToAll = false;
        try {
            this.stopEditing();
            int[] rows = this.m_descriptionTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUp() {
        try {
            int nRowIndex = this.m_descriptionTable.getSelectedRow();
            if (nRowIndex > 0) {
                this.m_tableModel.up(nRowIndex);
                this.m_descriptionTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDown() {
        try {
            int nRowIndex = this.m_descriptionTable.getSelectedRow();
            if (nRowIndex < this.m_tableModel.getRowCount() - 1) {
                this.m_tableModel.down(nRowIndex);
                this.m_descriptionTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onModifyText() {
        try {
            int rowIndex = this.m_descriptionTable.getSelectedRow();
            Description theDescription = this.m_tableModel.getDescription(rowIndex);
            if (theDescription != null) {
                VWUDDIDescriptionEditDialog editDialog = new VWUDDIDescriptionEditDialog(this.m_parentFrame, theDescription);
                editDialog.setVisible(true);
                int retStatus = editDialog.getReturnStatus();
                if (retStatus == 0 && editDialog.hasChanged()) {
                    Description retDescription = editDialog.getDescription();
                    this.m_tableModel.setDescription(retDescription, rowIndex);
                }
                editDialog.releaseResources();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

